### Controllo di versione di GAzie 

Chi è interessato a contribuire allo sviluppo ed al miglioramento può avvalersi del sistema di controllo di versione SVN messo a disposizione dal portale sourceforge.net al seguente indirizzo

#### GAzie Coding Standards

Tutti i file di codice sorgente nella distribuzione GAzie dovrebbero contenere il seguente blocco di commento come intestazione:

```
<?php
/*
  -------------------------------------------------------------------
  GAzie - Gestione Azienda
  Copyright (C) 2004-2018 Antonio De Vincentiis Montesilvano (PE)
  (http://www.devincentiis.it)
  <http://gazie.sourceforge.net>
  -------------------------------------------------------------------
  Questo programma e` free software;   e` lecito redistribuirlo  e/o
  modificarlo secondo i  termini della Licenza Pubblica Generica GNU
  come e` pubblicata dalla Free Software Foundation; o la versione 2
  della licenza o (a propria scelta) una versione successiva.

  Questo programma  e` distribuito nella speranza  che sia utile, ma
  SENZA   ALCUNA GARANZIA; senza  neppure  la  garanzia implicita di
  NEGOZIABILITA` o di  APPLICABILITA` PER UN  PARTICOLARE SCOPO.  Si
  veda la Licenza Pubblica Generica GNU per avere maggiori dettagli.

  Ognuno dovrebbe avere   ricevuto una copia  della Licenza Pubblica
  Generica GNU insieme a   questo programma; in caso  contrario,  si
  scriva   alla   Free  Software Foundation, 51 Franklin Street,
  Fifth Floor Boston, MA 02110-1335 USA Stati Uniti.
  -------------------------------------------------------------------
 */
?>
```

Non esiste una regola facile per determinare quando un collaboratore che apporta nuovo codice dovrebbe essere aggiunto alla lista degli autori di un dato file sorgente. In generale, le modifiche dovrebbero rientrare nella categoria "sostanziale" (che significa intorno al 10% - 20% delle modifiche del file). Eccezioni possono essere fatte per riscrivere le funzioni o per contribuire a nuova logica. Semplici correzioni, riorganizzazione o segnalazioni di bug non giustificherebbe l'aggiunta di un nuovo individuo alla lista degli autori.
Tabulazione e colonne

Per scrivere codice con i moderni editor di testo non è strettamente necessario usare i canonici 4 spazi di rientro per le tabulazioni e 80 colonne per rigo come nello standard Emacs. GAzie usa sempre caratteri spazio in luogo di quelli di tabulazione. Per approfondire l'argomento si può far riferimento a questo link: PEAR coding standards

```
(defun php-mode-hook ()
  (setq tab-width 4
        c-basic-offset 4
        c-hanging-comment-ender-p nil
        indent-tabs-mode
        (not
         (and (string-match "/\\(PEAR\\|pear\\)/" (buffer-file-name))
              (string-match "\.php$" (buffer-file-name))))))
```